<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Application extends Model 
{

    protected $table = 'Applications';
    public $timestamps = true;

    public function creator()
    {
        return $this->belongsTo('User');
    }

    public function district()
    {
        return $this->belongsTo('District');
    }

    public function school()
    {
        return $this->belongsTo('School');
    }

    public function scoresheets()
    {
        return $this->hasMany('Scoresheet');
    }

    public function answers()
    {
        return $this->morphMany('Answer');
    }

    public function contacts()
    {
        return $this->hasMany('Contact');
    }

    public function documents()
    {
        return $this->hasMany('Document');
    }

    public function sections()
    {
        return $this->morphMany('AssignedSection');
    }

}