<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('tirage_id')->references('id')->on('tirages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('lottery_id')->references('id')->on('lotteries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('numbers', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('numbers', function(Blueprint $table) {
			$table->foreign('tirage_id')->references('id')->on('lotteries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tirages', function(Blueprint $table) {
			$table->foreign('lottery_id')->references('id')->on('lotteries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('limits', function(Blueprint $table) {
			$table->foreign('tirage_id')->references('id')->on('tirages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('limits', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blockednumber', function(Blueprint $table) {
			$table->foreign('tirage_id')->references('id')->on('tirages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blockednumber', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('historyLimits', function(Blueprint $table) {
			$table->foreign('limit_id')->references('id')->on('limits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_content', function(Blueprint $table) {
			$table->foreign('tirage_id')->references('id')->on('tickets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_content', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_tirage_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_user_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_lottery_id_foreign');
		});
		Schema::table('numbers', function(Blueprint $table) {
			$table->dropForeign('numbers_ticket_id_foreign');
		});
		Schema::table('numbers', function(Blueprint $table) {
			$table->dropForeign('numbers_tirage_id_foreign');
		});
		Schema::table('tirages', function(Blueprint $table) {
			$table->dropForeign('tirages_lottery_id_foreign');
		});
		Schema::table('limits', function(Blueprint $table) {
			$table->dropForeign('limits_tirage_id_foreign');
		});
		Schema::table('limits', function(Blueprint $table) {
			$table->dropForeign('limits_game_id_foreign');
		});
		Schema::table('blockednumber', function(Blueprint $table) {
			$table->dropForeign('blockednumber_tirage_id_foreign');
		});
		Schema::table('blockednumber', function(Blueprint $table) {
			$table->dropForeign('blockednumber_game_id_foreign');
		});
		Schema::table('historyLimits', function(Blueprint $table) {
			$table->dropForeign('historyLimits_limit_id_foreign');
		});
		Schema::table('ticket_content', function(Blueprint $table) {
			$table->dropForeign('ticket_content_tirage_id_foreign');
		});
		Schema::table('ticket_content', function(Blueprint $table) {
			$table->dropForeign('ticket_content_game_id_foreign');
		});
	}
}