<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('phone', 20)->unique();
			$table->integer('age');
			$table->integer('blood_type_id')->unsigned();
			$table->integer('number_of_bags');
			$table->text('message');
			$table->integer('hospital_address_id')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->integer('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}