<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateZvaTable extends Migration {

	public function up()
	{
		Schema::create('zva', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('reg_num');
			$table->integer('object_inital_id');
			$table->string('object_name', 255)->nullable();
			$table->string('object_type', 255)->nullable();
			$table->string('lic_code', 255)->nullable();
			$table->tinyInteger('lic_status')->nullable();
			$table->date('suspended_from')->nullable();
			$table->string('object_addr_nice', 255)->nullable();
			$table->boolean('pharm_manager')->default(0);
			$table->string('object_email', 255)->nullable();
			$table->string('object_phone', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('zva');
	}
}