<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArpa3stepsTable extends Migration {

	public function up()
	{
		Schema::create('arpa3steps', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->integer('arpa3configurator_id');
			$table->integer('arpa3onglets_id')->unique();
			$table->integer('id_option_group');
			$table->tinyInteger('required_step')->default('0');
			$table->tinyInteger('display_recap')->default('1');
			$table->tinyInteger('multiple_choice')->default('0');
			$table->tinyInteger('is_text')->default('0');
			$table->integer('text_max_char')->default('0');
			$table->string('linked_step', 255)->nullable();
			$table->decimal('price', 8,2)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('arpa3steps');
	}
}