<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccPurchaseQuote extends Model 
{

    protected $table = 'acc_purchase_quote';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('footer_id', 'supplier_id', 'date', 'reference', 'description', 'title', 'status', 'amount', 'request_for_quotation', 'withholding_tax_type', 'withholding_tax', 'cancelled', 'show_item_image', 'sub_total', 'total', 'user_id', 'show_withholding_tax');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'purchase_quote_id');
    }

}