<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccProductionCost extends Model 
{

    protected $table = 'acc_production_cost';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('balance_sheet_account_id', 'profit_loss_accoun_id', 'amount', 'production_order_id', 'division_id', 'place_id', 'division_place_id', 'user_id');

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function profit_loss_accoun()
    {
        return $this->belongsTo('AccProfitLossAccount', 'profit_loss_accoun_id');
    }

    public function balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'balance_sheet_account_id');
    }

    public function production_order()
    {
        return $this->belongsTo('AccProductionOrder', 'production_order_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}