<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccPayslipItem extends Model 
{

    protected $table = 'acc_payslip_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'status', 'user_id', 'category_id', 'balance_sheet_acount_id', 'profit_loss_account_id', 'reporting_category_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function reporting_category()
    {
        return $this->belongsTo('AccReportingCategory', 'reporting_category_id');
    }

    public function profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'profit_loss_account_id');
    }

    public function balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'balance_sheet_account_id');
    }

    public function category()
    {
        return $this->belongsTo('AccPayslipItemCategory', 'category_id');
    }

}