<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInventoryWriteOff extends Model 
{

    protected $table = 'acc_inventory_write_off';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'reference', 'description', 'inventory_id', 'balance_sheet_account_id', 'profit_loss_account_id', 'division_id', 'place_id', 'division_place_id', 'project_id', 'total', 'user_id', 'tax_code_id');

    public function item_stores()
    {
        return $this->hasMany('AccItemStore', 'inventory_write_off_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

    public function balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'balance_sheet_account_id');
    }

    public function profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'profit_loss_account_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function project()
    {
        return $this->belongsTo('AccProject', 'project_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function tax_code()
    {
        return $this->belongsTo('AccTaxCode', 'tax_code_id');
    }

}