<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInventoryKit extends Model 
{

    protected $table = 'acc_inventory_kit';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name_en', 'name_ar', 'unit_name_en', 'unit_name_ar', 'division_id', 'place_id', 'division_place_id', 'description', 'sales_price', 'sales_division_id', 'sales_division_place_id', 'sales_place_id', 'tax_code_id', 'income_account_id', 'user_id', 'status', 'unit_price');

    public function items()
    {
        return $this->hasMany('AccItemStore', 'inventory_kit_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function sales_division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'sales_division_place_id');
    }

    public function sales_place()
    {
        return $this->belongsTo('AccPlace', 'sales_place_id');
    }

    public function sales_division()
    {
        return $this->belongsTo('AccDivision', 'sales_division_id');
    }

    public function tax_code()
    {
        return $this->belongsTo('AccTaxCode', 'tax_code_id');
    }

    public function income_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'income_account_id');
    }

}