<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInventory extends Model 
{

    protected $table = 'acc_inventory';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function inventory_items()
    {
        return $this->belongsToMany('AccInventoryItem', 'inventory_item_id', 'inventory_id', 'inventory_item_amount_id');
    }

}