<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccIntangibleAsset extends Model 
{

    protected $table = 'acc_intangible_asset';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name_en', 'name_ar', 'amortization_rate', 'description', 'user_id', 'division_id', 'place_id', 'division_place_id', 'control_account_cost_id', 'control_account_amortization_id', 'acquisition_cost', 'acccumulated_amortization', 'profit_loss_account_id', 'date_disposal', 'disposal_account_id', 'status', 'book_value', 'amortization');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function control_account_cost()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_cost_id');
    }

    public function control_account_amortization()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_amortization_id');
    }

    public function profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'profit_loss_account_id');
    }

    public function disposal_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'disposal_account_id');
    }

    public function entries()
    {
        return $this->belongsToMany('AccAssetEntry', 'intangible_asset_id', 'asset_entry_id', 'asset_entry_item_id');
    }

}