<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccGoodsReceipt extends Model 
{

    protected $table = 'acc_goods_receipt';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'reference', 'purchase_order_id', 'purchase_invoice_id', 'supplier_id', 'inventory_id', 'description', 'quantity', 'title', 'footer_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function purchase_invoice()
    {
        return $this->belongsTo('AccPurchaseInvoice', 'purchase_invoice_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function purchase_order()
    {
        return $this->belongsTo('AccPurchaseOrder', 'purchase_order_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'goods_receipt_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

}