<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccDebitNote extends Model 
{

    protected $table = 'acc_debit_note';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'reference', 'supplier_id', 'purchase_invoice_id', 'description', 'amount', 'tax_inclusive', 'total', 'footer_id', 'sub_total');

    public function items()
    {
        return $this->hasMany('AccItem', 'debit_note_id');
    }

    public function purchase_invoice()
    {
        return $this->belongsTo('AccPurchaseInvoice', 'purchase_invoice_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

}