<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCurrencyRevaluation extends Model 
{

    protected $table = 'acc_currency_revaluation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'total_item', 'total_gain', 'unrealized_gain', 'description', 'user_id');

    public function items()
    {
        return $this->hasMany('AccCurrencyRevaluationaItem', 'currency_revaluation_id');
    }

    public function currencies()
    {
        return $this->hasMany('AccCurrencyCurrency', 'currency_revaluation_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}