<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCurrencyCurrency extends Model 
{

    protected $table = 'Acc_currency_currency';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('currency_id', 'currency_revaluation_id', 'realized_gain', 'user_id');

    public function currency_revaluation()
    {
        return $this->belongsTo('AccCurrencyRevaluation', 'currency_revaluation_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}