<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccBankRule extends Model 
{

    protected $table = 'acc_bank_rule';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'type', 'bank_account_id', 'description', 'amount', 'amount_type', 'paid_by_type', 'other_name', 'customer_id', 'supplier_id');

    public function items()
    {
        return $this->hasMany('AccItem', 'bank_rule_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'bank_account_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

}