<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccAssetEntry extends Model 
{

    protected $table = 'acc_asset_entry';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'reference', 'description', 'amount');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function items()
    {
        return $this->hasMany('AccAssetEntryItem', 'asset_entry_id');
    }

    public function fixed_assets()
    {
        return $this->hasMany('AccFixedAsset', 'asset_enter_id');
    }

    public function intangible_assets()
    {
        return $this->hasMany('AccIntangibleAsset', 'asset_enter_id');
    }

    public function division_places()
    {
        return $this->hasMany('AccDivisionPlace', 'asset_enter_id');
    }

}