<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArtigosTable extends Migration {

	public function up()
	{
		Schema::create('artigos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('menu_id')->unsigned()->nullable();
			$table->integer('categoria_id')->unsigned()->nullable();
			$table->text('titulo');
			$table->longText('texto');
			$table->datetimeTz('modificado_em');
			$table->integer('parent')->nullable();
			$table->mediumText('link');
		});
	}

	public function down()
	{
		Schema::drop('artigos');
	}
}