<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Artigo extends Model 
{

    protected $table = 'artigos';
    public $timestamps = true;
    protected $fillable = array('titulo');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function categorias()
    {
        return $this->belongsToMany('Categoria');
    }

    public function comentarios()
    {
        return $this->hasMany('Comentario');
    }

    public function menus()
    {
        return $this->belongsToMany('Menu');
    }

}