<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlatesTable extends Migration {

	public function up()
	{
		Schema::create('plates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->text('description')->nullable();
			$table->bigInteger('category_id')->nullable();
			$table->string('image', 255);
			$table->boolean('active')->default(1);
			$table->integer('quantity')->default('1');
			$table->string('weight', 255)->nullable();
			$table->bigInteger('restaurant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('plates');
	}
}