<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIngredientsTable extends Migration {

	public function up()
	{
		Schema::create('ingredients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->float('price', 8,2)->default('0');
			$table->bigInteger('category_id')->unsigned();
			$table->boolean('active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('ingredients');
	}
}