<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255)->unique()->nullable();
			$table->string('phone', 255)->unique()->nullable();
			$table->string('password', 255);
			$table->timestamp('verified_at');
			$table->enum('payment_method', array('cash', 'card', 'google'));
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}