<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->string('name', 50);
			$table->string('email', 50);
			$table->string('phone');
			$table->string('password', 50);
			$table->date('date_of_birth');
			$table->date('last_donation_date');
			$table->string('pin_code')->nullable();
			$table->integer('blood_type_id')->unsigned();
			$table->integer('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}