<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFollowsTable extends Migration {

	public function up()
	{
		Schema::create('follows', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('follower');
			$table->morphs('followee');
			$table->enum('status', array('pending', 'accepted', 'rejected', 'cancelled'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('follows');
	}
}