<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function groups()
    {
        return $this->hasMany('Group');
    }

    public function follows()
    {
        return $this->morphMany('Follow');
    }

    public function blocks()
    {
        return $this->morphMany('Block');
    }

    public function wishlistCategories()
    {
        return $this->belongsToMany('WishlistCategory');
    }

    public function favoriteStores()
    {
        return $this->hasMany('FavoriteStore');
    }

    public function postRatings()
    {
        return $this->morphMany('PostRating');
    }

    public function point()
    {
        return $this->morphOne('Point');
    }

    public function posts()
    {
        return $this->morphMany('Post');
    }

}