<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function likes()
	{
		return $this->morphToMany('Likek');
	}

	public function targetGroups()
	{
		return $this->hasMany('PostTargetGroup');
	}

	public function groupExclusions()
	{
		return $this->belongsToMany('PostTargetGroupExclusion', 'post_id');
	}

	public function attachments()
	{
		return $this->morphMany('Attachment');
	}

	public function views()
	{
		return $this->morphMany('View');
	}

	public function comments()
	{
		return $this->morphMany('Comment');
	}

	public function ratings()
	{
		return $this->hasMany('PostRating');
	}

}