<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('commentable');
			$table->morphs('author');
			$table->bigInteger('parent_id')->unsigned();
			$table->longText('body');
			$table->enum('type', array('text', 'record', 'record_text'));
			$table->bigInteger('comments_count')->default('1');
			$table->bigInteger('likes_count')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}