<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostRatingsTable extends Migration {

	public function up()
	{
		Schema::create('post_ratings', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('userable');
			$table->morphs('rateable');
			$table->bigInteger('post_id')->unsigned();
			$table->decimal('rate')->default('0');
			$table->text('comment')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('post_ratings');
	}
}