<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePointsTable extends Migration {

	public function up()
	{
		Schema::create('points', function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('pointable');
			$table->decimal('point')->default('0');
			$table->decimal('available_point')->default('0');
			$table->decimal('debt_point')->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('points');
	}
}