<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FundHistory extends Model 
{

    protected $table = 'fund_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'fund_id', 'fund_account_id', 'credit', 'debit', 'type', 'balance');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function fund()
    {
        return $this->belongsTo('Fund', 'fund_id');
    }

    public function fund_account()
    {
        return $this->belongsTo('FundAccount', 'fund_account_id');
    }

}