<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FundAccount extends Model 
{

    protected $table = 'fund_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('fund_id', 'currency_id', 'amount');

    public function fund()
    {
        return $this->belongsTo('Fund', 'fund_id');
    }

    public function currency()
    {
        return $this->belongsTo('Currency', 'currency_id');
    }

    public function fund_histories()
    {
        return $this->hasMany('FundHistory', 'fund_account_id');
    }

}