<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoice';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('customer_name', 'phone', 'date', 'country', 'city', 'container_number', 'note');

	public function invoice_items()
	{
		return $this->hasMany('InvoiceItem', 'invoice_id');
	}

}