<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ContainerClient extends Eloquent {

	protected $table = 'container_client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'container_id');

	public function container()
	{
		return $this->belongsTo('Container', 'container_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function container_items()
	{
		return $this->hasMany('ContainerItem', 'container_client_id');
	}

}