<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Container extends Eloquent {

	protected $table = 'container';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('number', 'type', 'price', 'company_id', 'from_port_id', 'to_port_id', 'date', 'locked', 'details', 'note');

	public function to_port()
	{
		return $this->belongsTo('Port', 'to_port_id');
	}

	public function from_port()
	{
		return $this->belongsTo('Port', 'from_port_id');
	}

	public function company()
	{
		return $this->belongsTo('ShippingCompany', 'company_id');
	}

	public function container_clients()
	{
		return $this->hasMany('ContainerClient', 'container_id');
	}

}