<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClientFundHistory extends Eloquent {

	protected $table = 'client_fund_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'client_fund_id', 'credit_before', 'credit_after', 'amount_add', 'amount_deduct', 'details', 'type', 'user_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function client_fund()
	{
		return $this->belongsTo('ClientFund', 'client_fund_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}