<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_number', 'name', 'fax', 'phone', 'mobile', 'mark', 'company', 'country_id', 'city_id', 'user_id');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function client_funds()
	{
		return $this->hasMany('ClientFund', 'client_id');
	}

}