<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContainerTable extends Migration {

	public function up()
	{
		Schema::create('container', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('number')->nullable();
			$table->enum('type', array('40fot', '20fot'))->nullable();
			$table->double('price')->nullable();
			$table->integer('company_id')->nullable();
			$table->integer('from_port_id')->nullable();
			$table->integer('to_port_id')->nullable();
			$table->datetime('date')->nullable();
			$table->boolean('locked')->nullable()->default(0);
			$table->text('details')->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('container');
	}
}