<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('account_number')->nullable();
			$table->string('name')->nullable();
			$table->string('fax')->nullable();
			$table->string('phone')->nullable();
			$table->string('mobile')->nullable();
			$table->string('mark')->nullable();
			$table->string('company')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}