<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientFundHistoryTable extends Migration {

	public function up()
	{
		Schema::create('client_fund_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->nullable();
			$table->integer('client_fund_id')->nullable();
			$table->double('credit_before')->nullable();
			$table->double('credit_after')->nullable();
			$table->double('amount_add')->nullable();
			$table->double('amount_deduct')->nullable();
			$table->text('details')->nullable();
			$table->string('type')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client_fund_history');
	}
}