<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('sub_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('advertisement_id')->references('id')->on('advertisements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('iban')->references('id')->on('ibans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ibans', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advertisements_reasons', function(Blueprint $table) {
			$table->foreign('advertisement_id')->references('id')->on('advertisements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advertisements_reasons', function(Blueprint $table) {
			$table->foreign('partenership_reason_id')->references('id')->on('partenership_reasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advertisements_tasks', function(Blueprint $table) {
			$table->foreign('advertisement_id')->references('id')->on('advertisements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advertisements_tasks', function(Blueprint $table) {
			$table->foreign('partenership_task_id')->references('id')->on('advertisements_tasks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->dropForeign('sub_categories_category_id_foreign');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->dropForeign('advertisements_user_id_foreign');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->dropForeign('advertisements_sub_category_id_foreign');
		});
		Schema::table('advertisements', function(Blueprint $table) {
			$table->dropForeign('advertisements_city_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_user_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_advertisement_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_bank_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_iban_foreign');
		});
		Schema::table('ibans', function(Blueprint $table) {
			$table->dropForeign('ibans_bank_id_foreign');
		});
		Schema::table('advertisements_reasons', function(Blueprint $table) {
			$table->dropForeign('advertisements_reasons_advertisement_id_foreign');
		});
		Schema::table('advertisements_reasons', function(Blueprint $table) {
			$table->dropForeign('advertisements_reasons_partenership_reason_id_foreign');
		});
		Schema::table('advertisements_tasks', function(Blueprint $table) {
			$table->dropForeign('advertisements_tasks_advertisement_id_foreign');
		});
		Schema::table('advertisements_tasks', function(Blueprint $table) {
			$table->dropForeign('advertisements_tasks_partenership_task_id_foreign');
		});
	}
}