<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingTable extends Migration {

	public function up()
	{
		Schema::create('booking', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('consultationId')->unsigned();
			$table->integer('patientId')->unsigned()->index();
			$table->integer('doctorId')->unsigned()->index();
			$table->string('status', 50)->default('pending');
			$table->string('paymentMethod');
			$table->text('comment');
		});
	}

	public function down()
	{
		Schema::drop('booking');
	}
}