<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function threads()
    {
        return $this->hasMany('Thread');
    }

    public function posts()
    {
        return $this->hasMany('Post');
    }

    public function polls()
    {
        return $this->hasMany('Poll');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

}