<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned();
			$table->string('sender');
			$table->string('receiver');
			$table->bigInteger('delivery_id')->unsigned();
			$table->decimal('discount');
			$table->decimal('delivery_cost');
			$table->decimal('total_cost');
			$table->text('notes');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}