<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationsTable extends Migration {

	public function up()
	{
		Schema::create('Operations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('date_debut');
			$table->bigInteger('command_id')->unsigned();
			$table->date('date_fin');
			$table->enum('status', array(''));
			$table->bigInteger('team_id')->unsigned();
			$table->bigInteger('secture_id')->unsigned();
			$table->enum('type', array('poi', 'entretien', 'finalisation', 'GC', 'Gpon'));
			$table->string('Position', 250);
		});
	}

	public function down()
	{
		Schema::drop('Operations');
	}
}