<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('programs', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('id_with_org');
			$table->bigInteger('id_org')->unsigned();
			$table->string('name', 500);
			$table->bigInteger('price_per_qty');
			$table->string('code', 500)->nullable()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('programs');
	}
}