<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('id_with_org')->unique();
			$table->bigInteger('id_org')->unsigned();
			$table->bigInteger('id_contacts_types')->unsigned();
			$table->string('code', 200);
			$table->string('name', 300);
			$table->string('email', 300)->nullable();
			$table->string('address', 500)->nullable();
			$table->string('no_hp', 200)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}