<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('shop_id')->unsigned();
			$table->string('product_name', 191);
			$table->string('product_image', 191);
			$table->double('product_price');
			$table->longText('product_description');
			$table->bigInteger('product_quantity');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}