<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('professional_id')->unsigned();
			$table->bigInteger('shop_id')->nullable();
			$table->bigInteger('owner_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->string('status', 191);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}