<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFoodItemTable extends Migration {

	public function up()
	{
		Schema::create('food_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('client_id')->unsigned();
			$table->string('name');
			$table->string('image');
			$table->string('base_price')->nullable();
			$table->bigInteger('category_id')->unsigned();
			$table->enum('item_status', array('outOfStock', 'available', 'willTakeTime'));
			$table->boolean('is_drink')->default(0);
			$table->boolean('is_hard_drink')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('food_item');
	}
}